﻿using gov.va.med.vbecs.BOL;
using System;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class BloodUnitItemViewModel : SelectableTestViewModel
    {
        /// <summary>
        /// PendingBloodUnitTestModel
        /// </summary>
        public IPendingBloodUnitTestModel PendingBloodUnitTestModel
        {
            get
            {
                return PendingTestModel as IPendingBloodUnitTestModel;
            }
            set
            {
                PendingTestModel = value;
                RaisePropertyChanged(() => PendingBloodUnitTestModel);
            }
        }

        /// <summary>
        /// ProductCode setup as a property here so we can RaisePropertyChanged
        /// which will trigger an update in the UI
        /// </summary>
        private BloodUnitModel _bloodUnitModel;
        public BloodUnitModel BloodUnitModel
        {
            get
            {
                return _bloodUnitModel;
            }
            set
            {
                _bloodUnitModel = value;
                RaisePropertyChanged(() => BloodUnitModel);
                // Re-Validate the test when the Blood Unit changes
                TestValidation = PendingBloodUnitTestModel.Validate(_bloodUnitModel);
            }
        }

        /// <summary>
        /// PromptForBloodUnit
        /// </summary>
        public bool PromptForBloodUnit { get; private set; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="pendingBloodUnitModel"></param>
        public BloodUnitItemViewModel(IPendingBloodUnitTestModel pendingBloodUnitModel)
            : base(pendingBloodUnitModel)
        {
            if (pendingBloodUnitModel == null) throw new ArgumentNullException("pendingBloodUnitModel");
            PromptForBloodUnit = pendingBloodUnitModel.BloodUnitModel == null;
            ReviewComment = pendingBloodUnitModel.ReviewComment;

            // Make new references via clone so we can check for unsaved changes easier
            if (pendingBloodUnitModel.BloodUnitModel != null)
            {
                BloodUnitModel = pendingBloodUnitModel.BloodUnitModel.Clone();
            }
            if (pendingBloodUnitModel.TestValidation != null)
            {
                TestValidation = pendingBloodUnitModel.TestValidation.Clone();
            }
        }

        /// <summary>
        /// Check for unsaved changes
        /// </summary>
        /// <returns></returns>
        public override bool IsDirty()
        {
            return (ReviewComment != PendingTestModel.ReviewComment)
                || !Equals(BloodUnitModel, PendingBloodUnitTestModel.BloodUnitModel)
                || !Equals(TestValidation, PendingBloodUnitTestModel.TestValidation);
        }
    }
}
